--
--   Copyright (C) 2020 Ron Prusia
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program.  If not, see <http://www.gnu.org/licenses.
--
-- PWM 16-bit
--
-- March, 2020
--         
-- Ron Prusia
--
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
--
entity pwm16_ctrl is
generic (
  clk_divide    : integer := 50;
  period_count  : integer := 50000;
  min_count     : integer := 1000;
  max_count     : integer := 2000;
  invert_output : bit := '0'
  );
port (
  clk        : in bit;						--Clock input 
  pwm_cnt_in : in unsigned(15 downto 0); --
--
  pwm_out    : out bit
  );
end pwm16_ctrl;
--
architecture rtl of pwm16_ctrl is
--
-- Variables
--
  signal clk_cnt  : unsigned(11 downto 0);
  signal clk_cout : bit; --clock divide carry out
  signal pwm_cnt  : unsigned(15 downto 0);
  signal pwm_ff   : bit;
--
begin
  pwm_out <= pwm_ff when (invert_output = '0') else NOT pwm_ff; --invert or normal
--
-- Clock processes, state machine and counter
--
  clk_proc : process(clk,pwm_cnt,clk_cnt)
  begin
--  
    if (clk'event) AND (clk = '1') then 
      if (clk_cnt = clk_divide - 1) then
        clk_cnt <= x"000";
        clk_cout <= '1';
      else 
        clk_cnt <= clk_cnt + 1;
        clk_cout <= '0';
      end if;
--
      if (clk_cout = '1') AND (pwm_cnt = period_count - 1) then pwm_cnt <= x"0000"; --timer from zero to period count
      elsif (clk_cout = '1') then pwm_cnt <= pwm_cnt + 1;
      else pwm_cnt <= pwm_cnt;
      end if;
--
      if ((pwm_cnt < pwm_cnt_in) AND (pwm_cnt < max_count)) OR 
         (pwm_cnt < min_count) then pwm_ff <= '1';
      else pwm_ff <= '0';
      end if;
    end if;
--
  end process clk_proc;
end;
