library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
--
entity dac_deltasig is
  generic (nbits : integer :=16);
  port (clk   : in  std_logic;
        din   : in  signed((nbits-1) downto 0);
        dout  : out std_logic);
  end dac_deltasig;

architecture Behavioral of dac_deltasig is
  signal del1, del2, d_q : signed(nbits+2 downto 0) := (others => '0');
  constant c1            : signed(nbits+2 downto 0) := to_signed(1, nbits+3);
  constant c_1           : signed(nbits+2 downto 0) := to_signed(-1, nbits+3);
begin  -- beh1
  process (clk)
  variable v1, v2 : signed(nbits+2 downto 0) := (others => '0');
  begin  -- process
    if clk'event and clk = '1' then  -- rising clock edge
      v1 := din - d_q + del1;
      v2 := v1 - d_q + del2;
      if v2 > 0 then
        d_q  <= shift_left(c1, nbits);
        dout <= '1';
      else
        d_q  <= shift_left(c_1, nbits);
        dout <= '0';
      end if;
      del1 <= v1;
      del2 <= v2;
    end if;
  end process;
end;