import serial
import time
import math
#
# DDS Modes
# 0 - sinewave
# 1 - squarewave
# 2 - saw tooth
# 3 - triangle
# 4 - noise
# 5 - arbritary memory
# 6 - DC plus max
# 7 - DC minus max
#
def gain(value): # 0 to 0x7FFF
    x = b'\x90\xeb\x01\x02\x06\x00'
    x = x + value.to_bytes(2,byteorder='little')
    ser.write(x)
    time.sleep(0.1)
def offset(value): # 0 to 0x7FFF or negative
    x = b'\x90\xeb\x01\x02\x07\x00'
    x = x + value.to_bytes(2,byteorder='little')
    ser.write(x)
    time.sleep(0.1)
#
def dds1_mode(fvalue): # 0 to 7
    x = b'\x90\xeb\x01\x02\x0a\x00'
    x = x + int(fvalue).to_bytes(2,byteorder='little')
    ser.write(x)
    time.sleep(0.1)    
def dds1(fvalue): # in hertz
    x = b'\x90\xeb\x02\x02\x0b\x00'
    x = x + int(fvalue*85.899346).to_bytes(4,byteorder='little')
    ser.write(x)
    time.sleep(0.1)
#
def dds2_mode(fvalue): # 0 to 7
    x = b'\x90\xeb\x01\x02\x11\x04'
    x = x + int(fvalue).to_bytes(2,byteorder='little')
    ser.write(x)
    time.sleep(0.1)    

def dds2(fvalue): # in hertz
    x = b'\x90\xeb\x02\x02\x12\x04'
    x = x + int(fvalue*85.899346).to_bytes(4,byteorder='little')
    ser.write(x)
    time.sleep(0.1)
#
def wave1(value):
    if value == 0:  #sinewave
        x = b'\x90\xeb\x00\x03\x0f\x00'
        for y in range(0,256):
            z = 32767*math.sin(math.radians(360*y/1024))
            x = x + int(z).to_bytes(2,byteorder='little')
        ser.write(x)
        x = b'\x90\xeb\x00\x03\x0f\x01'
        for y in range(256,512):
            z = 32767*math.sin(math.radians(360*y/1024))
            x = x + int(z).to_bytes(2,byteorder='little')
        ser.write(x)
        x = b'\x90\xeb\x00\x03\x0f\x02'
        for y in range(512,768):
            z = 65535 + 32767*math.sin(math.radians(360*y/1024))
            x = x + int(z).to_bytes(2,byteorder='little')
        ser.write(x)
        x = b'\x90\xeb\x00\x03\x0f\x03'
        for y in range(768,1024):
            z = 65535 + 32767*math.sin(math.radians(360*y/1024))
            x = x + int(z).to_bytes(2,byteorder='little')
        ser.write(x)
    elif value == 1:  #squarewave
        x = b'\x90\xeb\x00\x03\x0f\x00'
        for y in range(0,256):
            x = x + b'\xff\x7f'
        ser.write(x)
        x = b'\x90\xeb\x00\x03\x0f\x01'
        for y in range(0,256):
            x = x + b'\xff\x7f'
        ser.write(x)
        x = b'\x90\xeb\x00\x03\x0f\x02'
        for y in range(0,256):
            x = x + b'\x00\x82'
        ser.write(x)
        x = b'\x90\xeb\x00\x03\x0f\x03'
        for y in range(0,256):
            x = x + b'\x00\x82'
        ser.write(x)
    elif value == 2:  #ramp, math as unsigned
        x = b'\x90\xeb\x00\x03\x0f\x00'        
        for y in range(0,256):
            z = 32768 + y*64.0616
            x = x + int(z).to_bytes(2,byteorder='little')
        ser.write(x)
        x = b'\x90\xeb\x00\x03\x0f\x01'
        for y in range(256,512):
            z = 32768 + y*64.0616
            x = x + int(z).to_bytes(2,byteorder='little')
        ser.write(x)
        x = b'\x90\xeb\x00\x03\x0f\x02'
        for y in range(0,256):
            z = y*64.0616
            x = x + int(z).to_bytes(2,byteorder='little')
        ser.write(x)
        x = b'\x90\xeb\x00\x03\x0f\x03'
        for y in range(256,512):
            z = y*64.0616
            x = x + int(z).to_bytes(2,byteorder='little')
        ser.write(x)
    elif value == 3:  #triangle, math as unsigned
        x = b'\x90\xeb\x00\x03\x0f\x00'        
        for y in range(0,256):
            z = 32768 + (y*128.248)
            x = x + int(z).to_bytes(2,byteorder='little')
        ser.write(x)
        x = b'\x90\xeb\x00\x03\x0f\x01'
        for y in range(0,256):
            z = y*128.248
            x = x + int(z).to_bytes(2,byteorder='little')
        ser.write(x)
        x = b'\x90\xeb\x00\x03\x0f\x02'
        for y in range(0,256):
            z = 32767 - (y*128.248)
            x = x + int(z).to_bytes(2,byteorder='little')
        ser.write(x)
        x = b'\x90\xeb\x00\x03\x0f\x03'
        for y in range(0,256):
            z = 65535 - (y*128.248)
            x = x + int(z).to_bytes(2,byteorder='little')
        ser.write(x)
    elif value == 4:  #arbritary
        x = b'\x90\xeb\x00\x03\x0f\x00'        
        for y in range(0,256):
            x = x + b'\x00\x00'
        ser.write(x)
        x = b'\x90\xeb\x00\x03\x0f\x01'
        for y in range(0,256):
            if y < 128: z = 1.98*y*y
            else: z = (256-y)*y*1.98
            x = x + int(z).to_bytes(2,byteorder='little')
        ser.write(x)
        x = b'\x90\xeb\x00\x03\x0f\x02'
        for y in range(0,256):
            x = x + b'\x00\x00'
        ser.write(x)
        x = b'\x90\xeb\x00\x03\x0f\x03'
        for y in range(0,256):
            x = x + b'\x00\x00'
        ser.write(x)  
#
def wave2(value):
    if value == 0:  #set value to 1, no modulation
        x = b'\x90\xeb\x00\x03\x16\x04'
        for y in range(0,256):
            x = x + b'\xff\x7f'
        ser.write(x)
        x = b'\x90\xeb\x00\x03\x16\x05'
        for y in range(0,256):
            x = x + b'\xff\x7f'
        ser.write(x)
        x = b'\x90\xeb\x00\x03\x16\x06'
        for y in range(0,256):
            x = x + b'\xff\x7f'
        ser.write(x)
        x = b'\x90\xeb\x00\x03\x16\x07'
        for y in range(0,256):
            x = x + b'\xff\x7f'
        ser.write(x)
    elif value == 1:  #set value to sinewave modulation 0%-100%
        x = b'\x90\xeb\x00\x03\x16\x04'
        for y in range(0,256):
            z = 16383*math.sin(math.radians(360*y/1024))+16383
            x = x + int(z).to_bytes(2,byteorder='little')
        ser.write(x)
        x = b'\x90\xeb\x00\x03\x16\x05'
        for y in range(256,512):
            z = 16383*math.sin(math.radians(360*y/1024))+16383
            x = x + int(z).to_bytes(2,byteorder='little')
        ser.write(x)
        x = b'\x90\xeb\x00\x03\x16\x06'
        for y in range(512,768):
            z = 16383*math.sin(math.radians(360*y/1024))+16383
            x = x + int(z).to_bytes(2,byteorder='little')
        ser.write(x)
        x = b'\x90\xeb\x00\x03\x16\x07'
        for y in range(768,1024):
            z = 16383*math.sin(math.radians(360*y/1024))+16383
            x = x + int(z).to_bytes(2,byteorder='little')
        ser.write(x)

# configure the serial connections 
ser = serial.Serial()
ser.baudrate = 115200
ser.port = 'COM8'
ser.open()
#
print(ser.name)             # check which port was really used
print(ser.is_open)
#
gain(29000)     #initial settings
offset(0)
wave1(4)        #arbritary memory
wave2(0)
dds1(10000)    #dds frequency
dds2(50000)
#
while True:
#  sinewave output
    dds1_mode(0)
    dds2_mode(6)
    for q in range(10):
        dds1(10000+20000*q)
        time.sleep(0.5)
#
    for q in range(1,8):
        dds1_mode(q)
        time.sleep(2)
    dds1(1000000)
    dds1_mode(0)
    dds2_mode(0)
    time.sleep(2)
#
ser.close()       

